from __future__ import generators
import plus
import Arenas
import random
import math

class ClawTop(Arenas.SuperArena):
    "Battle it out inside this mars base."
    name = "Mars Base"
    preview = "Mars2/dslmars_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']
    extent = (-13, 13, 14, -14)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/Mars2/mars2.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)

        fov = 0.015
        self.AddStaticCamera("              Overhead", (0, 55, -60), (1.5708,0), 72*fov)

        self.AddStaticCamera("              Static-1a", (0, 60, -20), (2.1, 0), 25*fov)
        self.AddStaticCamera("              Static-1b", (0, 60, -20), (2.1, 0), 35*fov)
        self.AddStaticCamera("              Static-1c", (0, 60, -20), (2.1, 0), 45*fov)

        self.AddStaticCamera("              Static-2", (-35, 20, -35), (2.35, -0.80), 75*fov)

        self.AddWatchCamera("               Watch-1a", (0, 10, -30), (6, 12, 30*fov, 15*fov))
        self.AddWatchCamera("               Watch-1b", (0, 10, -30), (6, 12, 30*fov, 30*fov))
        self.AddWatchCamera("               Watch-1c", (0, 10, -30), (6, 12, 30*fov, 50*fov))

        self.AddWatchCamera("               Watch-2a", (-30, 10, -90), (6, 12, 30*fov, 15*fov))
        self.AddWatchCamera("               Watch-2b", (-30, 10, -90), (6, 12, 30*fov, 30*fov))
        self.AddWatchCamera("               Watch-2c", (-30, 10, -90), (6, 12, 30*fov, 50*fov))

        self.AddWatchCamera("               Watch-3a", (-30, 10, -30), (6, 12, 30*fov, 15*fov))
        self.AddWatchCamera("               Watch-3b", (-30, 10, -30), (6, 12, 30*fov, 30*fov))
        self.AddWatchCamera("               Watch-3c", (-30, 10, -30), (6, 12, 30*fov, 50*fov))

        self.AddWatchCamera("               Watch-4a", (30, 10, -30), (6, 12, 30*fov, 15*fov))
        self.AddWatchCamera("               Watch-4b", (30, 10, -30), (6, 12, 30*fov, 30*fov))
        self.AddWatchCamera("               Watch-4c", (30, 10, -30), (6, 12, 30*fov, 50*fov))

        self.players = ()

    def Activate(self, on):
        if on: self.players = plus.getPlayers()
        
        Arenas.SuperArena.Activate(self, on)

    def HazardsOn(self, on):
        if on:

            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge01")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(2.7, 100)
            self.spinner.Lock(False)
            self.spinner.SetDirection(100)

            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge02")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(3, 100)
            self.spinner.Lock(False)
            self.spinner.SetDirection(100)

            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge03")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(3, 100)
            self.spinner.Lock(False)
            self.spinner.SetDirection(100)

            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge04")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(2.7, 100)
            self.spinner.Lock(False)
            self.spinner.SetDirection(100)

            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge05")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(0, 10000)
            self.spinner.Lock(False)
            self.spinner.SetDirection(-100)


            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge06")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(0, 10000)
            self.spinner.Lock(False)
            self.spinner.SetDirection(-100)


            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge07")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(0, 10000)
            self.spinner.Lock(False)
            self.spinner.SetDirection(-100)


            #Wheels on Buggy
            self.spinner = self.GetHinge("Hinge08")
            self.spinner.SetAutoLocks(False, True)
            self.spinner.SetPowerSettings(0, 10000)
            self.spinner.Lock(False)
            self.spinner.SetDirection(-100)

        else:
            pass
        
        return Arenas.SuperArena.HazardsOn(self, on)



        
Arenas.register(ClawTop)
